---
title: MiniGpt-4 API Usage Guide
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# MiniGpt-4 API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the MiniGpt-4 API, A model which generates text in response to an input image and prompt.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
    "image": "https://replicate.delivery/pbxt/IqG1MbemhULihtfr62URRZbI29XtcPsnOYASrTDQ6u5oSqv9/llama_13b.png",
    "top_p": 0.9,
    "prompt": "This llama's name is Dave. Write me a story about how Dave found his skateboard.",
    "num_beams": 5,
    "max_length": 4000,
    "temperature": 1.32,
    "max_new_tokens": 3000,
    "repetition_penalty": 1
  }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/minigpt-4@daanelson", data, price);
    // Handle response
    console.log("MiniGpt-4 result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `image` String,Provide the image url required for model inference
- `top_p` Number,Sample from the top p percent most likely tokens
- `prompt` String, Prompt for mini-gpt4 regarding input image
- `num_beams` Number,Number of beams for beam search decoding
- `max_length` Number,Total length of prompt and output in tokens
- `temperature` Number,Temperature for generating tokens, lower = more predictable results
- `max_new_tokens` Number,Maximum number of new tokens to generate
- `repetition_penalty` Number,Penalty for repeated words in generated text; 1 is no penalty, values greater than 1 discourage repetition, less than 1 encourage it.

### Notes

- Ensure that the provided audio URL is publicly accessible and of good quality to achieve the best cloning effect.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling voice samples of others.

### Example Response

The API response will contain the URL of the generated cloned voice or other relevant information. Parse and use the response data according to the actual API documentation.
